/** @file   GfxId.cpp
 * @brief   Implementation of GfxId class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/17 23:05:04 $
 * @author  Tomi Lamminsaari
 */

#include "GfxId.h"


namespace WeWantWar {


///
/// GfxIdPair - class
///

/** Constructor.
 */
GfxIdPair::GfxIdPair( int aCombineUid, int aGfxUid ) :
  iCombineUid( aCombineUid ),
  iGraphicUid( aGfxUid )
{
}

/** Destructor.
 */
GfxIdPair::~GfxIdPair()
{
}

/** Returns the combine uid.
 */
int GfxIdPair::CombineUid() const
{
  return iCombineUid;
}

/** Returns the graphic uid.
 */
int GfxIdPair::GraphicUid() const
{
  return iGraphicUid;
}

};  // end of namespace
